/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt.dsig.facets;

import com.microsoft.schemas.office.x2006.digsig.CTSignatureInfoV1;
import com.microsoft.schemas.office.x2006.digsig.SignatureInfoV1Document;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.poifs.crypt.dsig.facets.SignatureFacet;
import org.apache.poi.poifs.crypt.dsig.services.RelationshipTransformService;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.openxmlformats.schemas.xpackage.x2006.digitalSignature.CTSignatureTime;
import org.openxmlformats.schemas.xpackage.x2006.digitalSignature.SignatureTimeDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OOXMLSignatureFacet
extends SignatureFacet {
    private static final POILogger LOG = POILogFactory.getLogger(OOXMLSignatureFacet.class);
    public static final String[] contentTypes = new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml", "application/vnd.openxmlformats-officedocument.theme+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml", "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml", "application/vnd.ms-word.stylesWithEffects+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml", "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml", "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml", "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml", "application/vnd.openxmlformats-officedocument.presentationml.slide+xml", "application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml", "application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml", "application/vnd.openxmlformats-officedocument.presentationml.presProps+xml"};
    public static final String[] signed = new String[]{"powerPivotData", "activeXControlBinary", "attachedToolbars", "connectorXml", "downRev", "functionPrototypes", "graphicFrameDoc", "groupShapeXml", "ink", "keyMapCustomizations", "legacyDiagramText", "legacyDocTextInfo", "officeDocument", "pictureXml", "shapeXml", "smartTags", "ui/altText", "ui/buttonSize", "ui/controlID", "ui/description", "ui/enabled", "ui/extensibility", "ui/helperText", "ui/imageID", "ui/imageMso", "ui/keyTip", "ui/label", "ui/lcid", "ui/loud", "ui/pressed", "ui/progID", "ui/ribbonID", "ui/showImage", "ui/showLabel", "ui/supertip", "ui/target", "ui/text", "ui/title", "ui/tooltip", "ui/userCustomization", "ui/visible", "userXmlData", "vbaProject", "wordVbaData", "wsSortMap", "xlBinaryIndex", "xlExternalLinkPath/xlAlternateStartup", "xlExternalLinkPath/xlLibrary", "xlExternalLinkPath/xlPathMissing", "xlExternalLinkPath/xlStartup", "xlIntlMacrosheet", "xlMacrosheet", "customData", "diagramDrawing", "hdphoto", "inkXml", "media", "slicer", "slicerCache", "stylesWithEffects", "ui/extensibility", "chartColorStyle", "chartLayout", "chartStyle", "dictionary", "timeline", "timelineCache", "aFChunk", "attachedTemplate", "audio", "calcChain", "chart", "chartsheet", "chartUserShapes", "commentAuthors", "comments", "connections", "control", "customProperty", "customXml", "diagramColors", "diagramData", "diagramLayout", "diagramQuickStyle", "dialogsheet", "drawing", "endnotes", "externalLink", "externalLinkPath", "font", "fontTable", "footer", "footnotes", "glossaryDocument", "handoutMaster", "header", "hyperlink", "image", "mailMergeHeaderSource", "mailMergeRecipientData", "mailMergeSource", "notesMaster", "notesSlide", "numbering", "officeDocument", "oleObject", "package", "pivotCacheDefinition", "pivotCacheRecords", "pivotTable", "presProps", "printerSettings", "queryTable", "recipientData", "settings", "sharedStrings", "sheetMetadata", "slide", "slideLayout", "slideMaster", "slideUpdateInfo", "slideUpdateUrl", "styles", "table", "tableSingleCells", "tableStyles", "tags", "theme", "themeOverride", "transform", "video", "viewProps", "volatileDependencies", "webSettings", "worksheet", "xmlMaps", "ctrlProp", "customData", "diagram", "diagramColorsHeader", "diagramLayoutHeader", "diagramQuickStyleHeader", "documentParts", "slicer", "slicerCache", "vmlDrawing"};

    @Override
    public void preSign(Document document, List<Reference> references, List<XMLObject> objects) throws XMLSignatureException {
        LOG.log(1, "pre sign");
        this.addManifestObject(document, references, objects);
        this.addSignatureInfo(document, references, objects);
    }

    protected void addManifestObject(Document document, List<Reference> references, List<XMLObject> objects) throws XMLSignatureException {
        ArrayList<Reference> manifestReferences = new ArrayList<Reference>();
        this.addManifestReferences(manifestReferences);
        Manifest manifest = this.getSignatureFactory().newManifest(manifestReferences);
        String objectId = "idPackageObject";
        ArrayList<XMLStructure> objectContent = new ArrayList<XMLStructure>();
        objectContent.add(manifest);
        this.addSignatureTime(document, objectContent);
        XMLObject xo = this.getSignatureFactory().newXMLObject(objectContent, objectId, null, null);
        objects.add(xo);
        Reference reference = this.newReference("#" + objectId, null, "http://www.w3.org/2000/09/xmldsig#Object", null, null);
        references.add(reference);
    }

    protected void addManifestReferences(List<Reference> manifestReferences) throws XMLSignatureException {
        OPCPackage ooxml = this.signatureConfig.getOpcPackage();
        ArrayList<PackagePart> relsEntryNames = ooxml.getPartsByContentType("application/vnd.openxmlformats-package.relationships+xml");
        HashSet<String> digestedPartNames = new HashSet<String>();
        for (PackagePart pp : relsEntryNames) {
            PackageRelationshipCollection prc;
            String baseUri = pp.getPartName().getName().replaceFirst("(.*)/_rels/.*", "$1");
            try {
                prc = new PackageRelationshipCollection(ooxml);
                prc.parseRelationshipsPart(pp);
            }
            catch (InvalidFormatException e) {
                throw new XMLSignatureException("Invalid relationship descriptor: " + pp.getPartName().getName(), e);
            }
            RelationshipTransformService.RelationshipTransformParameterSpec parameterSpec = new RelationshipTransformService.RelationshipTransformParameterSpec();
            for (PackageRelationship relationship : prc) {
                String contentType;
                String relationshipType = relationship.getRelationshipType();
                if (TargetMode.EXTERNAL == relationship.getTargetMode() || !OOXMLSignatureFacet.isSignedRelationship(relationshipType)) continue;
                parameterSpec.addRelationshipReference(relationship.getId());
                String partName = relationship.getTargetURI().toString();
                if (!partName.startsWith(baseUri)) {
                    partName = baseUri + partName;
                }
                try {
                    partName = new URI(partName).normalize().getPath().replace('\\', '/');
                    LOG.log(1, "part name: " + partName);
                }
                catch (URISyntaxException e) {
                    throw new XMLSignatureException(e);
                }
                try {
                    PackagePartName relName = PackagingURIHelper.createPartName(partName);
                    PackagePart pp2 = ooxml.getPart(relName);
                    contentType = pp2.getContentType();
                }
                catch (InvalidFormatException e) {
                    throw new XMLSignatureException(e);
                }
                if (relationshipType.endsWith("customXml") && !contentType.equals("inkml+xml") && !contentType.equals("text/xml")) {
                    LOG.log(1, "skipping customXml with content type: " + contentType);
                    continue;
                }
                if (digestedPartNames.contains(partName)) continue;
                String uri = partName + "?ContentType=" + contentType;
                Reference reference = this.newReference(uri, null, null, null, null);
                manifestReferences.add(reference);
                digestedPartNames.add(partName);
            }
            if (!parameterSpec.hasSourceIds()) continue;
            ArrayList<Transform> transforms = new ArrayList<Transform>();
            transforms.add(this.newTransform("http://schemas.openxmlformats.org/package/2006/RelationshipTransform", parameterSpec));
            transforms.add(this.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
            String uri = pp.getPartName().getName() + "?ContentType=application/vnd.openxmlformats-package.relationships+xml";
            Reference reference = this.newReference(uri, transforms, null, null, null);
            manifestReferences.add(reference);
        }
    }

    protected void addSignatureTime(Document document, List<XMLStructure> objectContent) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT);
        fmt.setTimeZone(LocaleUtil.TIMEZONE_UTC);
        String nowStr = fmt.format(this.signatureConfig.getExecutionTime());
        LOG.log(1, "now: " + nowStr);
        SignatureTimeDocument sigTime = SignatureTimeDocument.Factory.newInstance();
        CTSignatureTime ctTime = sigTime.addNewSignatureTime();
        ctTime.setFormat("YYYY-MM-DDThh:mm:ssTZD");
        ctTime.setValue(nowStr);
        Element n = (Element)document.importNode(ctTime.getDomNode(), true);
        ArrayList<DOMStructure> signatureTimeContent = new ArrayList<DOMStructure>();
        signatureTimeContent.add(new DOMStructure(n));
        SignatureProperty signatureTimeSignatureProperty = this.getSignatureFactory().newSignatureProperty(signatureTimeContent, "#" + this.signatureConfig.getPackageSignatureId(), "idSignatureTime");
        ArrayList<SignatureProperty> signaturePropertyContent = new ArrayList<SignatureProperty>();
        signaturePropertyContent.add(signatureTimeSignatureProperty);
        SignatureProperties signatureProperties = this.getSignatureFactory().newSignatureProperties(signaturePropertyContent, "id-signature-time-" + this.signatureConfig.getExecutionTime());
        objectContent.add(signatureProperties);
    }

    protected void addSignatureInfo(Document document, List<Reference> references, List<XMLObject> objects) throws XMLSignatureException {
        ArrayList<SignatureProperties> objectContent = new ArrayList<SignatureProperties>();
        SignatureInfoV1Document sigV1 = SignatureInfoV1Document.Factory.newInstance();
        CTSignatureInfoV1 ctSigV1 = sigV1.addNewSignatureInfoV1();
        ctSigV1.setManifestHashAlgorithm(this.signatureConfig.getDigestMethodUri());
        Element n = (Element)document.importNode(ctSigV1.getDomNode(), true);
        n.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.microsoft.com/office/2006/digsig");
        ArrayList<DOMStructure> signatureInfoContent = new ArrayList<DOMStructure>();
        signatureInfoContent.add(new DOMStructure(n));
        SignatureProperty signatureInfoSignatureProperty = this.getSignatureFactory().newSignatureProperty(signatureInfoContent, "#" + this.signatureConfig.getPackageSignatureId(), "idOfficeV1Details");
        ArrayList<SignatureProperty> signaturePropertyContent = new ArrayList<SignatureProperty>();
        signaturePropertyContent.add(signatureInfoSignatureProperty);
        SignatureProperties signatureProperties = this.getSignatureFactory().newSignatureProperties(signaturePropertyContent, null);
        objectContent.add(signatureProperties);
        String objectId = "idOfficeObject";
        objects.add(this.getSignatureFactory().newXMLObject(objectContent, objectId, null, null));
        Reference reference = this.newReference("#" + objectId, null, "http://www.w3.org/2000/09/xmldsig#Object", null, null);
        references.add(reference);
    }

    protected static String getRelationshipReferenceURI(String zipEntryName) {
        return "/" + zipEntryName + "?ContentType=application/vnd.openxmlformats-package.relationships+xml";
    }

    protected static String getResourceReferenceURI(String resourceName, String contentType) {
        return "/" + resourceName + "?ContentType=" + contentType;
    }

    protected static boolean isSignedRelationship(String relationshipType) {
        LOG.log(1, "relationship type: " + relationshipType);
        for (String signedTypeExtension : signed) {
            if (!relationshipType.endsWith(signedTypeExtension)) continue;
            return true;
        }
        if (relationshipType.endsWith("customXml")) {
            LOG.log(1, "customXml relationship type");
            return true;
        }
        return false;
    }
}

